%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%% Lineares Einspurmodell (minimal)           %%%%%%%%
%%%%%%%% Parameter                                  %%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%% Prof. Dr. Mirek Gbel, 2020                %%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%-----------------------------------------------------------
% Reifen
%-----------------------------------------------------------
c_v             = 1.2E5;    %[N/rad]
c_h             = 2.5E5;    %[N/rad]

%-----------------------------------------------------------
% Laengen
%-----------------------------------------------------------
l_v             = 1.45;     %[m]
l               = 2.8;      %[m]
l_h             = l - l_v;

%-----------------------------------------------------------
% Massen
%-----------------------------------------------------------
m               = 1978;     %[kg]
J_zz            = 3255.86;  %[kg*m^2]

%-----------------------------------------------------------
% Sollgroessen
%-----------------------------------------------------------
% Geschwindigkeit
v               = 20;       %[m/s] immer groesser Null!!


%-----------------------------------------------------------
% Matrizen fr das Zustandsraummodell zusammensetzen
%-----------------------------------------------------------
A_11 = (-l_h^2 * c_h + l_v^2 * c_v) / J_zz / v;
A_12 = (l_h * c_h - l_v * c_v) / J_zz;
A_21 = (c_h * l_h - c_v * l_v - v^2 * m) / v^2 / m;
A_22 = -(c_v + c_h) / v / m;
ESM_A = [A_11, A_12; A_21, A_22];

B_11 = l_v * c_v / J_zz;
B_12 = -l_h * c_h / J_zz;
B_21 = c_v / v / m;
B_22 = -c_h / v / m;
ESM_B = [B_11, B_12; B_21, B_22];

ESM_C = [1 0; 0 1];

ESM_D = [0 0; 0 0];


open('mig_leismo_zustandsraum');



